﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Converters;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Printing;
using System.IO;
using System.Linq;
using System.Printing;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;



namespace AZVIC.Ei8htPOS.POSRetail.Helper
{
    public class ReceiptPrintHelper
    {
        static Orders _order;
        static string _remarks;

        public void PrintReceipt(Orders Order)
        {
            _order = Order;
            while (AppSession.CheckPrinterAssigned())
            {
                short receiptCount = GlobalConfigurations.AppConfiguration.ReceiptCount();

                for (int i = 0; i < receiptCount; i++)
                {
                    using (PrintDocument pd = new PrintDocument())
                    {
                        PrintDialog dialogPrint = new PrintDialog();
                        dialogPrint.AllowPrintToFile = true;
                        dialogPrint.AllowSomePages = true;
                        dialogPrint.PrinterSettings.MinimumPage = 1;
                        dialogPrint.PrinterSettings.MaximumPage = 1;
                        dialogPrint.PrinterSettings.FromPage = 1;
                        dialogPrint.PrinterSettings.ToPage = 1;
                        dialogPrint.Document = pd;
                        pd.PrintPage += new PrintPageEventHandler(pd_PrintPage);
                        pd.PrinterSettings.PrinterName = Properties.Settings.Default.InvoicePrinter;
                        pd.Print();
                    }
                }
                break;
            }

        }

        private void pd_PrintPage(object sender, PrintPageEventArgs ev)
        {
            Graphics graphics = ev.Graphics;
            Brush BlackColor = Brushes.Black;
            Font Headlinefont = new Font("Times New Roman", 18, FontStyle.Regular, GraphicsUnit.Point);
            Font TitleFont = new Font("Times New Roman", 12, FontStyle.Bold, GraphicsUnit.Point);
            Font TableHeaderFont = new Font("Times New Roman", 10, FontStyle.Regular, GraphicsUnit.Point);
            Font ParagraphFont = new Font("Times New Roman", 9, FontStyle.Regular, GraphicsUnit.Point);
            Font HighlightFont = new Font("Times New Roman", 9, FontStyle.Italic, GraphicsUnit.Point);
            Pen dashStyle = new Pen(Brushes.Black) { DashStyle = System.Drawing.Drawing2D.DashStyle.Dot };

            int LineHeight = 19;
            int startX = 45;
            int startY = 0;
            int Offset = 10;
            int fWidth = 280;
            string captions = string.Empty;

            #region Header Area
            // Create a StringFormat object with the each line of text, and the block 
            // of text centered on the page.
            Rectangle fullwidth = new Rectangle(Offset, startY, fWidth, 35);

            StringFormat centerSF = new StringFormat();
            centerSF.Alignment = StringAlignment.Center;

            StringFormat rightSF = new StringFormat();
            rightSF.Alignment = StringAlignment.Far;

            StringFormat stringFormat = new StringFormat();
            stringFormat.Alignment = StringAlignment.Far;
            stringFormat.LineAlignment = StringAlignment.Far;

            try
            {
                var imageLogo = Image.FromFile(AppSession.AppLogoPath + "logo.jpg");
                graphics.DrawImage(imageLogo, 90, startY, 100, 50);
                startY += 55;
            }
            catch { }

            graphics.DrawString(AppSession.ShopName, TitleFont, BlackColor, new Rectangle(Offset, startY, fWidth, 35), centerSF);

            startY += LineHeight;
            fullwidth = new Rectangle(Offset, startY, fWidth, 60);
            graphics.DrawString(AppSession.ShopAddress.Replace(@"\n", Environment.NewLine), ParagraphFont, BlackColor, fullwidth, centerSF);

            startY += LineHeight + 40;
            fullwidth = new Rectangle(Offset, startY, fWidth, 35);
            graphics.DrawString("RECEIPT", Headlinefont, BlackColor, fullwidth, centerSF);

            startY += LineHeight + 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startX = Offset;
            startY += 10;
            graphics.DrawString("Receipt #", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.OrderNumber.ToString(), ParagraphFont, BlackColor, startX, startY);

            //startX = Offset;
            //startY += LineHeight;
            //graphics.DrawString("Table #", ParagraphFont, BlackColor, startX, startY);
            //startX = 114;
            //graphics.DrawString(_order.TableNumber, ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));
            #endregion

            #region Main Table
            startX = Offset;
            startY += 10;
            graphics.DrawString("Item", TableHeaderFont, BlackColor, startX, startY);

            startX = 160;
            graphics.DrawString("Qty", TableHeaderFont, BlackColor, startX, startY);

            startX = 200;
            graphics.DrawString("Price", TableHeaderFont, BlackColor, startX, startY);

            startX = 245;
            graphics.DrawString("Total", TableHeaderFont, BlackColor, startX, startY);

            startY += LineHeight;
            string ItemName = "", Qty, Price, TotalPrice;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            //int spacing = 8;
            startY += LineHeight;
            Rectangle rect2;
            foreach (OrdersDetails orderdetail in _order.OrdersDetailsList)
            {
                #region Item Name Logic
                //if (orderdetail.DisplayQuantity == 0)
                //{
                Guid productID = orderdetail.ProductID;
                string ProductName = AppSession.ProductsList.Where(a => a.UniqueID == productID).Select(a => a.ProductName).Single();
                bool MultipleSizes = AppSession.ProductsList.Where(a => a.ProductName == ProductName).Count() > 1;
                if (!MultipleSizes)
                {
                    ItemName = orderdetail.ProductName.Count() > 25 ? orderdetail.ProductName.Substring(0, 25) + ".." : orderdetail.ProductName;
                }
                else
                {
                    Guid ProductSizeID = AppSession.ProductsList.Where(a => a.UniqueID == productID).Select(a => a.ProductMeasurementID).Single();
                    string MeasurementName = AppSession.MeasurementList.Where(a => a.UniqueID == ProductSizeID).Select(a => a.MeasurementName).Single();
                    if (orderdetail.ProductName.Count() > 20)
                    {
                        ItemName = orderdetail.ProductName.Substring(0, 20) + ".(" + (MeasurementName.Count() > 9 ? MeasurementName.Substring(0, 9) : MeasurementName) + ")";
                    }
                    else
                    {
                        ItemName = orderdetail.ProductName + "(" + (MeasurementName.Count() > 9 ? MeasurementName.Substring(0, 9) : MeasurementName) + ")";
                    }
                }
                //}
                //else
                //{
                //    ItemName = orderdetail.ProductName.Substring(0, 20) + ".(" + (orderdetail.DisplayName.Count() > 9 ? orderdetail.DisplayName.Substring(0, 9) : orderdetail.DisplayName) + ")";
                //}
                #endregion

                Qty = orderdetail.Quantity.ToString();
                Price = orderdetail.UnitPrice.ToString("0.00");
                TotalPrice = orderdetail.Amount.ToString("0.00");

                startX = Offset;
                graphics.DrawString(ItemName, ParagraphFont, BlackColor, startX, startY);
                startX += 160;
                graphics.DrawString(Qty, ParagraphFont, BlackColor, startX, startY);
                startX += 20;
                rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                graphics.DrawString(Price, ParagraphFont, BlackColor, rect2, stringFormat);
                startX += 47;
                rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                graphics.DrawString(TotalPrice, ParagraphFont, BlackColor, rect2, stringFormat);

                Products _curProduct = AppSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).FirstOrDefault<Products>();
                if (AppSession.IsHappyHour && _curProduct.HappyHourPrice != 0.00M)
                {
                    startY += LineHeight;
                    startX = Offset;
                    graphics.DrawString("Happy Hour Discount", HighlightFont, BlackColor, startX, startY);
                    startX += 180;
                    rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + (_curProduct.UnitPrice - _curProduct.HappyHourPrice).ToString("0.00"), ParagraphFont, BlackColor, rect2, stringFormat);
                    startX += 47;
                    rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + ((_curProduct.UnitPrice - _curProduct.HappyHourPrice) * orderdetail.Quantity).ToString("0.00"), ParagraphFont, BlackColor, rect2, stringFormat);

                }
                if (orderdetail.DiscountValue != 0.00M)
                {
                    startY += LineHeight;
                    startX = Offset;
                    string DiscString = orderdetail.DiscountType.ToLower().Equals("percentage") ? orderdetail.DiscountValue.ToString("0") + "%" : "$" + orderdetail.DiscountValue.ToString("0.00");
                    string UnitDiscVal = orderdetail.DiscountType.ToLower().Equals("percentage") ? (orderdetail.UnitPrice * (orderdetail.DiscountValue / 100)).ToString("0.00") :
                        orderdetail.DiscountValue.ToString("0.00");
                    string TotalDiscVal = orderdetail.DiscountType.ToLower().Equals("percentage") ? (orderdetail.Quantity * orderdetail.UnitPrice * (orderdetail.DiscountValue / 100)).ToString("0.00") : (orderdetail.Quantity * orderdetail.DiscountValue).ToString("0.00");
                    graphics.DrawString(DiscString + " Discount", HighlightFont, BlackColor, startX, startY);
                    startX += 180;
                    rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + UnitDiscVal, ParagraphFont, BlackColor, rect2, stringFormat);
                    startX += 47;
                    rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + TotalDiscVal, ParagraphFont, BlackColor, rect2, stringFormat);
                }

                startY += LineHeight;
            }

            startY += 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            #region Subtotal, Total field
            startX = 90;
            startY += 8;
            graphics.DrawString("Sub Total", ParagraphFont, BlackColor, startX, startY);
            Rectangle rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString(_order.SubTotal.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            if (_order.Discount + _order.HappyHoursDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Discounts (-)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString((_order.Discount + _order.HappyHoursDiscount).ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            //if (_order.HappyHoursDiscount != 0.00M)
            //{
            //    startX = 90;
            //    startY += LineHeight;
            //    graphics.DrawString("Happy Hour Disc.", ParagraphFont, BlackColor, startX, startY);
            //    rect1 = new Rectangle(210, startY, 71, LineHeight);
            //    graphics.DrawString(_order.HappyHoursDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            //}

            if (_order.TotalDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Total Bill Disc. (-)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.TotalDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.ServiceTax != 0.00M)
            {
                startX = 90;
                startY += LineHeight;

                if (_order.ServiceTaxType.Trim().ToLower().Equals("dollar"))
                {
                    captions = "$" + _order.ServiceTaxValue.ToString() + " SVC";
                }
                else if (_order.ServiceTaxType.Trim().ToLower().Equals("percentage"))
                {
                    captions = _order.ServiceTaxValue.ToString("#") + "% SVC";
                }

                graphics.DrawString(captions + " (+)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.ServiceTax.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.GST != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("GST @ " + AppSession.GSTPercent + "% (+)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.GST.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.RoundedAmount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Rounding", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.RoundedAmount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset + 180, startY), new Point(287, startY));

            startX = 90;
            startY += 8;
            graphics.DrawString("Amount due", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString(_order.Total.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startX = 90;
            startY += LineHeight;
            graphics.DrawString("Cash", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString(_order.PaidAmount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startX = 90;
            startY += LineHeight;
            graphics.DrawString("Change", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString((_order.PaidAmount - _order.Total).ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            #region Content Table Area 2
            startX = Offset;
            startY += 8;
            graphics.DrawString("Cashier", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            var Cashier = UserAccountBL.GetItem(_order.AdminUserAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            var CashierName = Cashier != null ? string.Format("{0} {1}", Cashier.FirstName, Cashier.LastName) : string.Empty;
            graphics.DrawString(CashierName, ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Date", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.CreatedDate != DateTime.MinValue ? _order.CreatedDate.ToShortDateString() : DateTime.Now.ToShortDateString()
                , ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Time", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.CreatedDate != DateTime.MinValue ? _order.CreatedDate.ToString("hh:mm ss tt") : DateTime.Now.ToString("hh:mm ss tt")
                , ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            startY += LineHeight;
            startX = 75;
            fullwidth = new Rectangle(Offset, startY, fWidth, 50);
            graphics.DrawString(AppSession.ThankyouMessage.Replace(@"\n", Environment.NewLine), ParagraphFont, BlackColor, fullwidth, centerSF);
        }

        public void PrintToKitchen(Orders Order, string Remarks)
        {
            try
            {
                _order = Order;
                _remarks = Remarks;
                while (AppSession.CheckPrinterAssigned())
                {
                    using (PrintDocument pd = new PrintDocument())
                    {
                        PrintDialog dialogPrint = new PrintDialog();
                        dialogPrint.AllowPrintToFile = true;
                        dialogPrint.AllowSomePages = true;
                        //dialogPrint.PrinterSettings.MinimumPage = 1;
                        //dialogPrint.PrinterSettings.MaximumPage = 1;
                        //dialogPrint.PrinterSettings.FromPage = 1;
                        //dialogPrint.PrinterSettings.ToPage = 1;
                        dialogPrint.Document = pd;
                        pd.PrintPage += new PrintPageEventHandler(pd_PrintKitchenPage);
                        pd.PrinterSettings.PrinterName = Properties.Settings.Default.BarcodePrinter;
                        pd.Print();
                        break;
                    }
                }
            }
            catch (Exception ex)
            {

            }
        }

        private void pd_PrintKitchenPage(object sender, PrintPageEventArgs ev)
        {
            Graphics graphics = ev.Graphics;
            Brush BlackColor = Brushes.Black;
            Font Headlinefont = new Font("Times New Roman", 18, FontStyle.Regular, GraphicsUnit.Point);
            // Font TitleFont = new Font("Times New Roman", 17, FontStyle.Bold, GraphicsUnit.Point);
            Font TableHeaderFont = new Font("Times New Roman", 13, FontStyle.Regular, GraphicsUnit.Point);
            Font ParagraphFont = new Font("Times New Roman", 11, FontStyle.Regular, GraphicsUnit.Point);
            Pen dashStyle = new Pen(Brushes.Black) { DashStyle = System.Drawing.Drawing2D.DashStyle.Dot };
            int startX = 21;
            int startY = 20;
            int Offset = 10;
            int fWidth = 280;

            try
            {
                var imageLogo = Image.FromFile(AppSession.AppLogoPath + "logo.jpg");
                graphics.DrawImage(imageLogo, 90, startY, 100, 50);
            }
            catch { }

            startX = 21;
            startY += 50;

            Rectangle fullwidth = new Rectangle(Offset, startY, fWidth, 35);
            StringFormat centerSF = new StringFormat();
            centerSF.Alignment = StringAlignment.Center;
            StringFormat rightSF = new StringFormat();
            rightSF.Alignment = StringAlignment.Far;
            graphics.DrawString("Kitchen Receipt", Headlinefont, BlackColor, fullwidth, centerSF);

            int LineHeight = 19;

            startX = Offset;
            startY += 30;

            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));
            startY += 5;

            graphics.DrawString("Time : " + DateTime.Now.ToString("hh:mm ss tt"), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += 25;
            graphics.DrawString("Item", TableHeaderFont, BlackColor, startX, startY);

            startX = 155;
            //startY += 20;
            graphics.DrawString("Qty", TableHeaderFont, BlackColor, startX, startY);

            startX = 190;
            //startY += 20;
            graphics.DrawString("Size", TableHeaderFont, BlackColor, startX, startY);

            string ItemName, Qty, Size;
            startY += 22;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));
            startY += 20;

            foreach (OrdersDetails orderdetail in _order.OrdersDetailsList)
            {

                ItemName = orderdetail.ProductName.Count() > 20 ? orderdetail.ProductName.Substring(0, 20) + ".." : orderdetail.ProductName;
                Qty = orderdetail.Quantity.ToString();
                Size = "";
                Guid MeasurementID = AppSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).Select(a => a.ProductMeasurementID).Any() ? AppSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).Select(a => a.ProductMeasurementID).Single() : Guid.Empty;
                if (!MeasurementID.Equals(Guid.Empty))
                    Size = AppSession.MeasurementList.Where(a => a.UniqueID == MeasurementID).Select(a => a.MeasurementName).Single();
                Size = Size.Count() > 15 ? Size.Substring(0, 15) + ".." : Size;
                startX = Offset;
                graphics.DrawString(ItemName, ParagraphFont, BlackColor, startX, startY);
                startX += 155;
                graphics.DrawString(Qty, ParagraphFont, BlackColor, startX, startY);
                startX += 35;
                graphics.DrawString(Size, ParagraphFont, BlackColor, startX, startY);
                startY += LineHeight;
            }

            startY += 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startY += 15;
            startX = 115;
            graphics.DrawString("Remarks", ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += 2 * LineHeight;
            graphics.DrawString(_remarks, ParagraphFont, BlackColor, new Rectangle(Offset, startY, 280, 150), StringFormat.GenericTypographic);

        }

        public void PrintTaxInvoice(Orders Order)
        {
            _order = Order;
            while (AppSession.CheckPrinterAssigned())
            {
                int receiptCount = GlobalConfigurations.AppConfiguration.ReceiptCount();

                using (PrintDocument pd = new PrintDocument())
                {
                    PrintDialog dialogPrint = new PrintDialog();
                    dialogPrint.AllowPrintToFile = true;
                    dialogPrint.AllowSomePages = true;
                    dialogPrint.PrinterSettings.MinimumPage = 1;
                    dialogPrint.PrinterSettings.MaximumPage = 1;
                    dialogPrint.PrinterSettings.FromPage = 1;
                    dialogPrint.PrinterSettings.ToPage = 1;
                    dialogPrint.Document = pd;
                    pd.PrintPage += new PrintPageEventHandler(pd_PrintTaxInvoice);
                    pd.PrinterSettings.PrinterName = Properties.Settings.Default.InvoicePrinter;
                    pd.Print();
                    break;
                }
            }
        }

        private void pd_PrintTaxInvoice(object sender, PrintPageEventArgs ev)
        {
            Graphics graphics = ev.Graphics;
            Brush BlackColor = Brushes.Black;
            Font Headlinefont = new Font("Times New Roman", 18, FontStyle.Regular, GraphicsUnit.Point);
            Font TitleFont = new Font("Times New Roman", 12, FontStyle.Bold, GraphicsUnit.Point);
            Font TableHeaderFont = new Font("Times New Roman", 10, FontStyle.Regular, GraphicsUnit.Point);
            Font ParagraphFont = new Font("Times New Roman", 9, FontStyle.Regular, GraphicsUnit.Point);
            Font HighlightFont = new Font("Times New Roman", 9, FontStyle.Italic, GraphicsUnit.Point);
            Pen dashStyle = new Pen(Brushes.Black) { DashStyle = System.Drawing.Drawing2D.DashStyle.Dot };

            int LineHeight = 19;
            int startX = 45;
            int startY = 0;
            int Offset = 10;
            int fWidth = 280;
            string captions = string.Empty;

            #region Header Area
            // Create a StringFormat object with the each line of text, and the block 
            // of text centered on the page.
            Rectangle fullwidth = new Rectangle(Offset, startY, fWidth, 35);

            StringFormat centerSF = new StringFormat();
            centerSF.Alignment = StringAlignment.Center;

            StringFormat rightSF = new StringFormat();
            rightSF.Alignment = StringAlignment.Far;

            StringFormat stringFormat = new StringFormat();
            stringFormat.Alignment = StringAlignment.Far;
            stringFormat.LineAlignment = StringAlignment.Far;

            try
            {
                var imageLogo = Image.FromFile(AppSession.AppLogoPath + "logo.jpg");
                graphics.DrawImage(imageLogo, 90, startY, 100, 50);
                startY += 55;
            }
            catch { }

            graphics.DrawString(AppSession.ShopName, TitleFont, BlackColor, new Rectangle(Offset, startY, fWidth, 35), centerSF);

            startY += LineHeight;
            fullwidth = new Rectangle(Offset, startY, fWidth, 60);
            graphics.DrawString(AppSession.ShopAddress.Replace(@"\n", Environment.NewLine), ParagraphFont, BlackColor, fullwidth, centerSF);

            startY += LineHeight + 40;
            fullwidth = new Rectangle(Offset, startY, fWidth, 35);
            graphics.DrawString("RECEIPT", Headlinefont, BlackColor, fullwidth, centerSF);

            startY += LineHeight + 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startX = Offset;
            startY += 10;
            graphics.DrawString("Receipt #", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.OrderNumber.ToString(), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Table #", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.TableNumber, ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));
            #endregion

            #region Main Table
            startX = Offset;
            startY += 10;
            graphics.DrawString("Item", TableHeaderFont, BlackColor, startX, startY);

            startX = 160;
            graphics.DrawString("Qty", TableHeaderFont, BlackColor, startX, startY);

            startX = 200;
            graphics.DrawString("Price", TableHeaderFont, BlackColor, startX, startY);

            startX = 245;
            graphics.DrawString("Total", TableHeaderFont, BlackColor, startX, startY);

            startY += LineHeight;
            string ItemName, Qty, Price, TotalPrice;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            //int spacing = 8;
            startY += LineHeight;
            Rectangle rect2;
            foreach (OrdersDetails orderdetail in _order.OrdersDetailsList)
            {
                #region Item Name Logic
                Guid productID = orderdetail.ProductID;
                string ProductName = AppSession.ProductsList.Where(a => a.UniqueID == productID).Select(a => a.ProductName).Single();
                bool MultipleSizes = AppSession.ProductsList.Where(a => a.ProductName == ProductName).Count() > 1;
                if (!MultipleSizes)
                {
                    ItemName = orderdetail.ProductName.Count() > 30 ? orderdetail.ProductName.Substring(0, 30) + ".." : orderdetail.ProductName;
                }
                else
                {
                    Guid ProductSizeID = AppSession.ProductsList.Where(a => a.UniqueID == productID).Select(a => a.ProductMeasurementID).Single();
                    string MeasurementName = AppSession.MeasurementList.Where(a => a.UniqueID == ProductSizeID).Select(a => a.MeasurementName).Single();
                    if (orderdetail.ProductName.Count() > 20)
                    {
                        ItemName = orderdetail.ProductName.Substring(0, 20) + ".(" + (MeasurementName.Count() > 9 ? MeasurementName.Substring(0, 9) : MeasurementName) + ")";
                    }
                    else
                    {
                        ItemName = orderdetail.ProductName + "(" + (MeasurementName.Count() > 9 ? MeasurementName.Substring(0, 9) : MeasurementName) + ")";
                    }
                }
                #endregion

                Qty = orderdetail.Quantity.ToString();
                Price = orderdetail.UnitPrice.ToString("0.00");
                TotalPrice = orderdetail.Amount.ToString("0.00");

                startX = Offset;
                graphics.DrawString(ItemName, ParagraphFont, BlackColor, startX, startY);
                startX += 160;
                graphics.DrawString(Qty, ParagraphFont, BlackColor, startX, startY);
                startX += 20;
                rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                graphics.DrawString(Price, ParagraphFont, BlackColor, rect2, stringFormat);
                startX += 47;
                rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                graphics.DrawString(TotalPrice, ParagraphFont, BlackColor, rect2, stringFormat);

                Products _curProduct = AppSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).FirstOrDefault<Products>();
                if (AppSession.IsHappyHour && _curProduct.HappyHourPrice != 0.00M)
                {
                    startY += LineHeight;
                    startX = Offset;
                    graphics.DrawString("Happy Hour Discount", HighlightFont, BlackColor, startX, startY);
                    startX += 180;
                    rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + (_curProduct.UnitPrice - _curProduct.HappyHourPrice).ToString("0.00"), ParagraphFont, BlackColor, rect2, stringFormat);
                    startX += 47;
                    rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + ((_curProduct.UnitPrice - _curProduct.HappyHourPrice) * orderdetail.Quantity).ToString("0.00"), ParagraphFont, BlackColor, rect2, stringFormat);

                }
                if (orderdetail.DiscountValue != 0.00M)
                {
                    startY += LineHeight;
                    startX = Offset;
                    string DiscString = orderdetail.DiscountType.ToLower().Equals("percentage") ? orderdetail.DiscountValue.ToString("0") + "%" : "$" + orderdetail.DiscountValue.ToString("0.00");
                    string UnitDiscVal = orderdetail.DiscountType.ToLower().Equals("percentage") ? (orderdetail.UnitPrice * (orderdetail.DiscountValue / 100)).ToString("0.00") :
                        orderdetail.DiscountValue.ToString("0.00");
                    string TotalDiscVal = orderdetail.DiscountType.ToLower().Equals("percentage") ? (orderdetail.Quantity * orderdetail.UnitPrice * (orderdetail.DiscountValue / 100)).ToString("0.00") : (orderdetail.Quantity * orderdetail.DiscountValue).ToString("0.00");
                    graphics.DrawString(DiscString + " Discount", HighlightFont, BlackColor, startX, startY);
                    startX += 180;
                    rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + UnitDiscVal, ParagraphFont, BlackColor, rect2, stringFormat);
                    startX += 47;
                    rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                    graphics.DrawString("-" + TotalDiscVal, ParagraphFont, BlackColor, rect2, stringFormat);
                }

                startY += LineHeight;
            }

            startY += 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            #region Subtotal, Total field
            startX = 90;
            startY += 8;
            graphics.DrawString("Sub Total", ParagraphFont, BlackColor, startX, startY);
            Rectangle rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString(_order.SubTotal.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            if (_order.Discount + _order.HappyHoursDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Discounts (-)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString((_order.Discount + _order.HappyHoursDiscount).ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            //if (_order.HappyHoursDiscount != 0.00M)
            //{
            //    startX = 90;
            //    startY += LineHeight;
            //    graphics.DrawString("Happy Hour Disc.", ParagraphFont, BlackColor, startX, startY);
            //    rect1 = new Rectangle(210, startY, 71, LineHeight);
            //    graphics.DrawString(_order.HappyHoursDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            //}

            if (_order.TotalDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Total Bill Disc. (-)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.TotalDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.ServiceTax != 0.00M)
            {
                startX = 90;
                startY += LineHeight;

                if (_order.ServiceTaxType.Trim().ToLower().Equals("dollar"))
                {
                    captions = "$" + _order.ServiceTaxValue.ToString() + " SVC";
                }
                else if (_order.ServiceTaxType.Trim().ToLower().Equals("percentage"))
                {
                    captions = _order.ServiceTaxValue.ToString("#") + "% SVC";
                }

                graphics.DrawString(captions + " (+)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.ServiceTax.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.GST != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("GST @ " + AppSession.GSTPercent + "% (+)", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.GST.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.RoundedAmount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Rounding", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(210, startY, 71, LineHeight);
                graphics.DrawString(_order.RoundedAmount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset + 180, startY), new Point(287, startY));

            startX = 90;
            startY += 8;
            graphics.DrawString("Amount due", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(210, startY, 71, LineHeight);
            graphics.DrawString(_order.Total.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            //startX = 90;
            //startY += LineHeight;
            //graphics.DrawString("Cash", ParagraphFont, BlackColor, startX, startY);
            //rect1 = new Rectangle(210, startY, 71, LineHeight);
            //graphics.DrawString(_order.PaidAmount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            //startX = 90;
            //startY += LineHeight;
            //graphics.DrawString("Change", ParagraphFont, BlackColor, startX, startY);
            //rect1 = new Rectangle(210, startY, 71, LineHeight);
            //graphics.DrawString((_order.PaidAmount - _order.Total).ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            #region Content Table Area 2
            startX = Offset;
            startY += 8;
            graphics.DrawString("Cashier", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(string.Format("{0}", AppSession.CurrentAdminUser.FirstName), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Date", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.CreatedDate != DateTime.MinValue ? _order.CreatedDate.ToShortDateString() : DateTime.Now.ToShortDateString()
                , ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Time", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.CreatedDate != DateTime.MinValue ? _order.CreatedDate.ToString("hh:mm ss tt") : DateTime.Now.ToString("hh:mm ss tt")
                , ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            #endregion

            startY += LineHeight;
            startX = 75;
            fullwidth = new Rectangle(Offset, startY, fWidth, 50);
            graphics.DrawString(AppSession.ThankyouMessage.Replace(@"\n", Environment.NewLine), ParagraphFont, BlackColor, fullwidth, centerSF);
        }

        public void PrintDailyReport(System.Windows.Controls.ScrollViewer PrintElement)
        {
            //while (AppSession.CheckPrinterAssigned())
            //{
            //    using (PrintDocument pd = new PrintDocument())
            //    {
            //        System.Windows.Controls.PrintDialog dialogPrint = new System.Windows.Controls.PrintDialog();
            //        pd.PrinterSettings.PrinterName = Properties.Settings.Default.InvoicePrinter;
            //        //dialogPrint.Document = pd;
            //        dialogPrint.PrintQueue = new PrintQueue(new PrintServer(), Properties.Settings.Default.InvoicePrinter);
            //        dialogPrint.PrintVisual(PrintElement.Content as System.Windows.Media.Visual, "Printing Daily Report");
            //        break;
            //    }
            //}
            System.Windows.Controls.PrintDialog printDlg = new System.Windows.Controls.PrintDialog();

            if (printDlg.ShowDialog() == true)
            {
                System.Printing.PrintCapabilities capabilities = printDlg.PrintQueue.GetPrintCapabilities(printDlg.PrintTicket);

                double scale = Math.Min(capabilities.PageImageableArea.ExtentWidth / PrintElement.ActualWidth, capabilities.PageImageableArea.ExtentHeight /

                PrintElement.ActualHeight);

                PrintElement.LayoutTransform = new System.Windows.Media.ScaleTransform(scale, scale);

                System.Windows.Size sz = new System.Windows.Size(capabilities.PageImageableArea.ExtentWidth, capabilities.PageImageableArea.ExtentHeight);

                //update the layout of the visual to the printer page size.

                PrintElement.Measure(sz);

                PrintElement.Arrange(new System.Windows.Rect(new System.Windows.Point(capabilities.PageImageableArea.OriginWidth, capabilities.PageImageableArea.OriginHeight), sz));
                //now print the visual to printer to fit on the one page.

                printDlg.PrintVisual(PrintElement, "Report Printing");

                //PrintElement.LayoutTransform = new System.Windows.Media.ScaleTransform(1/scale, 1/scale);
            }
        }
    }
}
